function [pval score] = LMtest(y,X,Z)

% This subroutine performs the LM test, comparing the regressions using 
% y=Xb vs y=[X Z]b.
%
% Written by: Rudiyanto Gunawan
% Date: 14 February 2017

[n, K] =size(X);
P = size(Z,2);

% Perform OLS
b = (X'*X)\X'*y;
u = y-X*b; % residual
H = diag(X*((X'*X)\X'));

% Remove linear influence of X from Z
Xhat = [ones(n,1) X];
Zv = Z - Xhat*((Xhat'*Xhat)\Xhat')*Z;

% Compute score and p value
Om = diag((u.^2));
score = u'*Zv*(((n-K)/(n-K-P)*Zv'*Om*Zv)\(Zv'*u));
pval = 1 - chi2cdf(score,P);
